/** 
 * @file    kCudaDevice.x.h
 *
 * @internal
 * Copyright (C) 2019-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CUDA_DEVICE_X_H
#define K_FIRESYNC_CUDA_DEVICE_X_H


#define kCUDA_DEVICE_DEFAULT                (0)         //This library currently only support use of device zero.

/*
 * kCudaDevice static class
 */

typedef struct kCudaDeviceStatic
{
    k32s placeholder;
} kCudaDeviceStatic;

kDeclareStaticClassEx(kFs, kCudaDevice)

kFsFx(kStatus) xkCudaDevice_InitStatic();
kFsFx(kStatus) xkCudaDevice_ReleaseStatic();

/* 
*  Private methods
*/

kFsFx(kStatus) xkCudaDevice_Properties(kSize deviceIndex, kCudaProperties* properties);

/** 
 * Sets the Cuda device to be used by the current thread.
 *
 * @public          @memberof kCudaDevice
 * @param   index   Cuda device index.
 * @return          Operation status.
 */
kFsFx(kStatus) xkCudaDevice_Select(kSize index);


#endif
