/** 
 * @file    kSha256Hash.x.h
 *
 * @internal
 * Copyright (C) 2021-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_API_SHA256_HASH_X_H
#define K_API_SHA256_HASH_X_H

#define xkSHA256_HASH_DIGEST_SIZE       (32)

typedef struct kSha256HashClass
{
    kHashClass base;
    kPointer sha256Context;     //sha256 context -- forward decl.
} kSha256HashClass;

kDeclareClassEx(kFs, kSha256Hash, kHash)

/* 
 * Private methods. 
 */

kFsFx(kStatus) xkSha256Hash_Init(kSha256Hash, kType type, kAlloc alloc); 
kFsFx(kStatus) xkSha256Hash_VRelease(kSha256Hash hash);

kFsFx(kStatus) xkSha256Hash_VUpdate(kSha256Hash hash, const void* buffer, kSize size);
kFsFx(kStatus) xkSha256Hash_VDigest(kSha256Hash hash, void* buffer, kSize size);
kFsFx(kStatus) xkSha256Hash_VClear(kSha256Hash hash);

kFsFx(kSize) xkSha256Hash_VDigestSize(kSha256Hash hash);

#endif
