/** 
 * @file    kEncoder.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ENCODER_X_H
#define K_FIRESYNC_ENCODER_X_H

#define kENCODER_MIN_SIMULATION_PERIOD                  (1000)                //Minimum period (fs ns). 
#define kENCODER_MAX_SIMULATION_PERIOD                  (1000*(k16U_MAX/6))   //Maximum period, based on PL register (fs ns). 
#define kENCODER_SIMULATION_PERIOD_GRANULARITY          (1000)                //Period granularity
#define kENCODER_DEFAULT_SIMULATION_PERIOD              (1000000)             //Default period (fs ns). 

typedef struct kEncoderClass
{
    kObjectClass base; 
    kNode node; 

    kBool enabled;                          //Is the encoder enabled?
    kEncoderDirection direction;            //Defines interpretation of encoder A/B signals. 
    kBool indexResetEnabled;                //Is reset-on-index is enabled?
    kBool simulationEnabled;                //Is simulation enabled?
    kBool simulationDirection;              //Increasing (kTRUE) or decreasing (kFALSE)?
    k64u simulationPeriod;                  //Simulation period (fs ns).
    k32u simulationResolution;              //Simulation resolution.

    kEncoderSnapshotSource snapshotSource;  //Encoder snapshot source.
    k32u snapshotSourceId;                  //Encoder snapshot source id.
} kEncoderClass; 

kDeclareClassEx(kFs, kEncoder, kObject)
        
kFsFx(kStatus) kEncoder_Construct(kEncoder* encoder, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kEncoder_Init(kEncoder encoder, kType type, kNode node, kAlloc alloc); 
kFsFx(kStatus) kEncoder_VRelease(kEncoder encoder); 

kFsFx(kStatus) kEncoder_Parse(kEncoder encoder, kXml xml, kXmlItem item); 
kFsFx(kStatus) kEncoder_Format(kEncoder encoder, kXml xml, kXmlItem item); 

kFsFx(kStatus) kEncoder_ParseDevice(kEncoder encoder, kXml xml, kXmlItem item); 
kFsFx(kStatus) kEncoder_FormatDevice(kEncoder encoder, kXml xml, kXmlItem item); 

kFsFx(kStatus) kEncoder_VerificationLabel(kEncoder encoder, kChar* label, kSize capacity); 
kFsFx(kStatus) kEncoder_Verify(kEncoder encoder); 

kFsFx(kStatus) kEncoder_ClearEx(kEncoder encoder, kNodeClearOption options);

#endif
