/** 
 * @file    kProjectorSteps.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROJECTOR_STEPS_X_H
#define K_FIRESYNC_PROJECTOR_STEPS_X_H

typedef struct kProjectorStep
{
    kSize state;            //state index
    kSize count;            //repetition count
} kProjectorStep; 

kDeclareValueEx(kFs, kProjectorStep, kValue)

typedef struct kProjectorStepsClass
{
    kProjectorExtClass base; 
    kArrayList steps;              //Step list -- kArrayList<kProjectorStep>
    kProjectorStepsStyle style;    //Steps style
} kProjectorStepsClass; 

kDeclareClassEx(kFs, kProjectorSteps, kProjectorExt)
        
kFsFx(kStatus) xkProjectorSteps_Construct(kProjectorSteps* extension, kAlloc allocator); 

kFsFx(kStatus) kProjectorSteps_Init(kProjectorSteps extension, kType type, kSize initialCount, kAlloc alloc); 
kFsFx(kStatus) kProjectorSteps_VRelease(kProjectorSteps extension); 

kFsFx(kStatus) kProjectorSteps_VClone(kProjectorSteps extension, kProjectorSteps other, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kProjectorSteps_VRead(kProjectorSteps extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kProjectorSteps_VWrite(kProjectorSteps extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kProjectorSteps_VerificationLabel(kProjectorSteps extension, kChar* label, kSize capacity); 
kFsFx(kStatus) kProjectorSteps_VVerify(kProjectorSteps extension); 

kFsFx(kStatus) kProjectorSteps_VNextStates(kProjectorSteps extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 
kFsFx(k64u) kProjectorSteps_VMinimumPeriod(kProjectorSteps extension); 

kFsFx(kProjectorStep*) kProjectorSteps_StepAt(kProjectorSteps extension, kSize index); 

#define kProjectorSteps_Count_(S)                  kArrayList_Count(xkProjectorSteps_CastRaw(S)->steps)
#define kProjectorSteps_RepetitionCount_(S, I)     ((kArrayList_AtT(xkProjectorSteps_CastRaw(S)->steps, (I), kProjectorStep))->count)
#define kProjectorSteps_State_(S, I)               ((kArrayList_AtT(xkProjectorSteps_CastRaw(S)->steps, (I), kProjectorStep))->state)

#endif
