/** 
 * @file    kInvertAlg.x.h
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_INVERT_ALG_X_H
#define K_FIRESYNC_INVERT_ALG_X_H

typedef struct kInvertAlgVTable
{
    kObjectVTable base;

    kStatus (kCall* VExecute)(kInvertAlg algorithm, kImage input, kBool inputExclusive, kImage* output); 
} kInvertAlgVTable; 

typedef struct kInvertAlgClass
{
    kObjectClass base; 
    kInvertAlgParams params; 
} kInvertAlgClass; 

kDeclareVirtualClassEx(kFs, kInvertAlg, kObject)
        
kFsFx(kStatus) kInvertAlg_Init(kInvertAlg algorithm, kType type, const kInvertAlgParams* params, kAlloc alloc); 

kInlineFx(kStatus) kInvertAlg_VRelease(kInvertAlg algorithm)
{
    return kObject_VRelease(algorithm); 
}

kInlineFx(kStatus) kInvertAlg_VExecute(kInvertAlg algorithm, kImage input, kBool inputExclusive, kImage* output)
{
    return kERROR_UNIMPLEMENTED;
}

#endif
