#ifndef GSA_LIB_SENSOR_G3_PROPERTIES_H
#define GSA_LIB_SENSOR_G3_PROPERTIES_H

#include "SensorBase.h"

namespace GoSensorApp
{

namespace GoProp = Go::Properties;

struct IndependentExposures : public GoProp::Structure
{
    GoProp::Value<bool> enabled;
    MinMaxValue<k64f> frontExposure;
    MinMaxValue<k64f> backExposure;

    IndependentExposures()
    {
        Register("enabled", enabled);
        Register("frontExposure", frontExposure);
        Register("backExposure", backExposure);
    }
};

struct G3SensorSchema : public SensorBase
{
    IndependentExposures independentExposures;
    GoProp::Value<k32s> patternSequenceType;
    GoProp::Value<std::vector<k32s>> patternSequenceTypeOptions;
    GoProp::Value<k64u> patternSequenceCount;

    GoProp::Value<k32s> intensitySource;
    GoProp::Value<std::vector<k32s>> intensitySourceOptions;

    GoProp::Value<k32s> surfaceEncoding;
    GoProp::Value<bool> surfaceEncodingUsed;
    GoProp::Value<std::vector<k32s>> surfaceEncodingOptions;

    GoProp::Value<k32s> surfacePhaseFilter;
    GoProp::Value<bool> surfacePhaseFilterUsed;
    GoProp::Value<std::vector<k32s>> surfacePhaseFilterOptions;

    G3SensorSchema()
    {
        Register("independentExposures", independentExposures);
        Register("patternSequenceType", patternSequenceType);
        patternSequenceType.RegisterSchema("enum", patternSequenceTypeOptions);
        Register("patternSequenceCount", patternSequenceCount);

        Register("intensitySource", intensitySource);
        intensitySourceOptions.Set({ 0,1,2 });
        intensitySource.RegisterSchema("enum", intensitySourceOptions);

        Register("surfaceEncoding", surfaceEncoding);
        surfaceEncoding.RegisterSchema("used", surfaceEncodingUsed);
        surfaceEncoding.RegisterSchema("enum", surfaceEncodingOptions);

        Register("surfacePhaseFilter", surfacePhaseFilter);
        surfacePhaseFilter.RegisterSchema("used", surfacePhaseFilterUsed);
        surfacePhaseFilter.RegisterSchema("enum", surfacePhaseFilterOptions);
    }
};

}; // namespaces

#endif
