#ifndef GS_APP_H
#define GS_APP_H

#include <GoSensorAppLib/GsaDef.h>
#include <GoSensor/GsAppCfg.h>
#include <GoSensor/Core/GsCore.h>
#include <GoSensor/Remote/GsRemoteRegistrar.h>
#include <kFireSync/Server/kSvDef.h>
#include <kFireSync/kFsLib.h>

typedef kObject GsApp;

kDeclareClassEx(Gsa, GsApp, kObject)

typedef struct GsAppParams
{
    const kChar* localPath;
    kNode localNode;
    kNode mainNode;
    kSvNode localSvNode;
    kSystem system;
    kBool accelSuppressTimeout;
    kBool accelForceConnect;
    kAssembly userAsm;
    kAlloc messageAlloc;
} GsAppParams;

GsaFx(kStatus) GsApp_Construct(GsApp* app, const GsAppParams* params, GsAppCfg config, kAlloc allocator);

GsaFx(kStatus) GsApp_WaitForShutdown(GsApp app, k64u timeout);

GsaFx(GsCore) GsApp_Core(GsApp app);

#endif
