/**
 * @file    GoSdk.h
 * @brief   Includes all Gocator SDK headers.
 *
 * @internal
 * Copyright (C) 2017-2022 by LMI Technologies Inc.
 * Licensed under the MIT License.
 * Redistributed files must retain the above copyright notice.
 */
#ifndef GO_SDK_H
#define GO_SDK_H

#include <GoSdk/GoSdkDef.h>
#include <GoSdk/GoSdkLib.h>
#include <GoSdk/GoAccelerator.h>
#include <GoSdk/GoAcceleratorMgr.h>
#include <GoSdk/GoAlgorithm.h>
#include <GoSdk/GoPartModel.h>
#include <GoSdk/GoReplay.h>
#include <GoSdk/GoSections.h>
#include <GoSdk/GoSensor.h>
#include <GoSdk/GoSensorInfo.h>
#include <GoSdk/GoSetup.h>
#include <GoSdk/GoSystem.h>
#include <GoSdk/GoTracheid.h>
#include <GoSdk/GoGeoCal.h>
#include <GoSdk/GoTransform.h>
#include <GoSdk/GoUtils.h>
#include <GoSdk/Internal/GoAccelSensorPortAlloc.h>
#include <GoSdk/Internal/GoControl.h>
#include <GoSdk/Internal/GoDiscovery.h>
#include <GoSdk/Internal/GoReceiver.h>
#include <GoSdk/Internal/GoSerializer.h>
#include <GoSdk/Messages/GoDataSet.h>
#include <GoSdk/Messages/GoDataTypes.h>
#include <GoSdk/Messages/GoDiscoveryExtInfo.h>
#include <GoSdk/Messages/GoHealth.h>
#include <GoSdk/Outputs/GoOutput.h>
#include <GoSdk/Tools/GoMeasurement.h>
#include <GoSdk/Tools/GoMeasurements.h>
#include <GoSdk/Tools/GoFeature.h>
#include <GoSdk/Tools/GoFeatures.h>
#include <GoSdk/Tools/GoTool.h>
#include <GoSdk/Tools/GoTools.h>
#include <GoSdk/Tools/GoExtTool.h>
#include <GoSdk/Tools/GoExtToolDataOutput.h>

#endif
