/** 
 * @file    TestSurfaceSelect.x.h
 *
 * Copyright © 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef TOOL_TEST_SURFACE_SELECT_TOOL_Z_H
#define TOOL_TEST_SURFACE_SELECT_TOOL_Z_H

#define TEST_SURFACE_SELECT_TOOL_NAME        "TestSurfaceSelectTool"
#define TEST_SURFACE_SELECT_TOOL_LABEL        "Test Surface Select"

typedef enum TestSurfaceSelectMeasurement
{
    TEST_SURFACE_SELECT_MEASUREMENT_X = 0,
    TEST_SURFACE_SELECT_MEASUREMENT_Y,
    TEST_SURFACE_SELECT_MEASUREMENT_Z
} TestSurfaceSelectMeasurement;

typedef struct TestSurfaceSelectClass 
{
    GdkToolClass base;
    GdkDataSource dataSource;

    kBool useRegion;
    GdkRegion3d64f region;

    k32u indexX; // Index X to return data
    k32u indexY; // Index Y to return data
} TestSurfaceSelectClass;

kDeclareClassEx(Tool, TestSurfaceSelect, GdkTool)

ToolFx(kStatus) TestSurfaceSelect_VDescribe(GdkToolInfo info);

ToolFx(kStatus) TestSurfaceSelect_VInit(TestSurfaceSelect tool, kType type, kAlloc alloc);
ToolFx(kStatus) TestSurfaceSelect_VRelease(TestSurfaceSelect tool);
ToolFx(kStatus) TestSurfaceSelect_VUpdateConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);
ToolFx(kStatus) TestSurfaceSelect_VStart(TestSurfaceSelect tool);
ToolFx(kStatus) TestSurfaceSelect_VStop(TestSurfaceSelect tool);
ToolFx(kStatus) TestSurfaceSelect_VProcess(TestSurfaceSelect tool, GdkToolInput input, GdkToolOutput output);
ToolFx(kStatus) TestSurfaceSelect_OutputValue(GdkToolOutput output, kSize index, k64f value, GdkMeasurementDecision decision, GdkToolCfg config);

#endif
