#ifndef GDK_DATA_INFO_Z_H
#define GDK_DATA_INFO_Z_H

#include <Gdk/Utils/GdkDataInfo.h>
#include <kApi/Data/kXml.h>

typedef struct GdkDataInfoClass 
{
    kObjectClass base;

    GdkDataType type;
    GdkDataSource source;
    kBool hasIntensity;
    k32s streamStep;
    k32s streamId;
    kPoint3d64f scale;
    kPoint3d64f origin;
    GdkRegion3d64f region;
} GdkDataInfoClass;

GdkFx(kStatus) GdkDataInfo_Init(GdkDataInfo info, kType type, kAlloc alloc);
GdkFx(kStatus) GdkDataInfo_VRelease(GdkDataInfo info);
GdkFx(kStatus) GdkDataInfo_VInitClone(GdkDataInfo object, GdkDataInfo source, kAlloc allocator); 

GdkFx(kStatus) GdkDataInfo_Construct(GdkDataInfo* info, kAlloc alloc);

GdkFx(kStatus) GdkDataInfo_Read(GdkDataInfo info, kXml xml, kXmlItem root);
GdkFx(kStatus) GdkDataInfo_Write(GdkDataInfo info, kXml xml, kXmlItem root);

GdkFx(kStatus) GdkDataInfo_SetType(GdkDataInfo info, GdkDataType type);
GdkFx(kStatus) GdkDataInfo_SetSource(GdkDataInfo info, GdkDataSource source);
GdkFx(kStatus) GdkDataInfo_SetStreamId(GdkDataInfo info, k32s id);
GdkFx(kStatus) GdkDataInfo_SetStreamStep(GdkDataInfo info, k32s step);
GdkFx(kStatus) GdkDataInfo_SetHasIntensity(GdkDataInfo info, kBool hasIntensity);
GdkFx(kStatus) GdkDataInfo_SetScale(GdkDataInfo info, const kPoint3d64f* scale);
GdkFx(kStatus) GdkDataInfo_SetOrigin(GdkDataInfo info, const kPoint3d64f* origin);
GdkFx(kStatus) GdkDataInfo_SetRegion(GdkDataInfo info, const GdkRegion3d64f* region);

GdkFx(k32s) GdkDataInfo_StreamStep(GdkDataInfo info);
GdkFx(k32s) GdkDataInfo_StreamId(GdkDataInfo info);

GdkFx(const kPoint3d64f*) GdkDataInfo_Origin(GdkDataInfo info);

GdkFx(kStatus) GdkDataInfo_ReadV0(GdkDataInfo info, kSerializer serializer, kAlloc allocator);
GdkFx(kStatus) GdkDataInfo_WriteV0(GdkDataInfo info, kSerializer serializer);

#endif
