// 
// KException.h
// 
// Copyright (C) 2014-2022 by LMI Technologies Inc.
// Licensed under the MIT License.
// Redistributed files must retain the above copyright notice.
// 
#ifndef K_API_NET_EXCEPTION_H
#define K_API_NET_EXCEPTION_H

#include "kApiNet/KApiDef.h"

namespace Lmi3d
{
    namespace Zen
    {
        /// <summary>Represents an error generated by an underlying Zen-based library.</summary>
        public ref class KException : public Exception
        {
        public:
            /// <summary>Constructs a new KException instance with the specified status code.</summary>
            /// <param name="status">Status code.</param>
            KException(kStatus status)
            {
                Status = static_cast<KStatus>(status);

                m_message = String::Format("A Zen API error occurred ({0}, {1}).", Status, (int)Status);
            }

            virtual property String^ Message
            {
                String^ get() override
                {
                    return m_message;
                }
            }

            /// <summary>Gets the status code associated with the error.</summary>
            property KStatus Status;

        private:
            String^ m_message;
        };
    }
}

#endif
